<?php
header("Access-Control-Allow-Origin: http://myproject.local"); // or "*"
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");



// Enable full errors for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);





// Upload folder relative to this PHP file
$uploadDir = __DIR__ . "/Assets/Profile/";

// Create folder if it doesn't exist
if (!file_exists($uploadDir)) {
    if (!mkdir($uploadDir, 0777, true)) {
        die("ERROR: Could not create upload folder. Check permissions.");
    }
}

// Check if file is received
if (!isset($_FILES['image'])) {
    die("ERROR: No file received. Make sure your JS fetch is correct.");
}


// Store uploaded file info
$fileTmpPath = $_FILES['image']['tmp_name'];
$fileOriginalName = $_FILES['image']['name'];

// Get the phone number from the custom header
$phoneNumber = '';
if (isset($_SERVER['HTTP_X_PHONE_ID'])) {
    $phoneNumber = $_SERVER['HTTP_X_PHONE_ID'];
} else if (isset($_POST['phoneId'])) {
    $phoneNumber = $_POST['phoneId'];
}

// If we have a phone number, use it as the base filename
// Otherwise, fall back to the original logic
if (!empty($phoneNumber)) {
    // Determine if this is a profile or banner image based on the original filename
    $imageType = 'profile'; // default to profile
    if (strpos($fileOriginalName, 'banner') !== false) {
        $imageType = 'banner';
    }
    
    // Create filename as [phone_number]_[image_type].png
    $newFileName = $phoneNumber . '_' . $imageType . ".png";
} else {
    // Get the ID from the filename (e.g., profile-image.png -> profile-image -> profile)
    $fileNameWithoutExtension = pathinfo($fileOriginalName, PATHINFO_FILENAME);
    $id = $fileNameWithoutExtension;

    // If the filename contains "profile" or "banner", use that as the ID
    if (strpos($fileNameWithoutExtension, 'profile') !== false) {
        $id = 'profile';
    } else if (strpos($fileNameWithoutExtension, 'banner') !== false) {
        $id = 'banner';
    }

    // Create the new filename as ID.png (force PNG format)
    $newFileName = $id.".png";
}

$destPath = $uploadDir.$newFileName;

// Move uploaded file to the uploads folder (this will overwrite if file exists)
if (move_uploaded_file($fileTmpPath, $destPath)) {
    echo "SUCCESS: File uploaded to Assets/Profile/$newFileName";
} else {
    echo "ERROR: Could not move file. Check folder permissions.";
}
?>